#ifndef __PERIPH_H__
#define __PERIPH_H__

#define       DAC_EN                1    //使能DAC
#define       DAC_DIS               0    //禁止DAC

#define       DAC_VDD               1    //DAC参考电压选择VDD
#define       DAC_FVR               0    //DAC参考电压选择FVR

#define       DAC_0                 0    //Vdac = (1/5)DAC_VREF+[(n+1)/40]DAC_VREF, n = DAC[3:0] in decimal
#define       DAC_1                 1    //Vdac = [(n+1)/32]DAC_VREF, n = DAC[3:0] in decimal
#define       DAC_2                 2    //VDAC = (1/4)DAC_VREF+[(n+1)/32]DAC_VREF, n = DAC[3:0] in decimal
#define       DAC_3                 3    //Vdac = [(n+1)/24]DAC_VREF, n = DAC[3:0] in decimal

#define       FVROUT_EN             1    //使能FVR输出
#define       FVROUT_DIS            0    //禁止FVR输出

#define       FVRPGA_1              1    //1倍
#define       FVRPGA_2              2    //2倍
#define       FVRPGA_3              3    //3倍

#define       FVR_SEL_0             0    //PA3
#define       FVR_SEL_1             1    //VREF1P0(1.0V)
#define       FVR_SEL_2             2    //1/4VDD
#define       FVR_SEL_3             3    //NTC
#define       FVR_SEL_4             4    //DACOUT
#define       FVR_SEL_5             5    //TCKS(仅内部使用）
#define       FVR_SEL_6             6    //BGR_OUT（仅内部使用）
#define       FVR_SEL_7             7    //VLCD（仅内部使用）

#define       FVR_OFFSET_EN         1    //允许使能 
#define       FVR_OFFSET_DIS        0    //禁止使能

// #define       FVR_TRIM                   //FVR的校准值

void GPIO_Init(void);

void FVR_Init(unsigned char FVROUT,unsigned char FVRPGA,unsigned char FVR_SEL,unsigned char FVROFFSET,unsigned char FVR_TRIM);
/*******************************************************************************
 *   Function  :    FVR_Init   FVR配置
 *   Parameters:
 *     FVROUT(输出使能)           
 *                              FVROUT_EN             1    //使能FVR输出         
 *                              FVROUT_DIS            0    //禁止FVR输出 
 *     FVRPGA(电压放大倍数)       
 *                              FVRPGA_1              1    //1倍
 *                              FVRPGA_2              2    //2倍
 *                              FVRPGA_3              3    //3倍
 *     FVR_SEL(FVR电压选择)       
 *                              FVR_SEL_0             0    //PA3         
 *                              FVR_SEL_1             1    //VREF1P0(1.0V)
 *                              FVR_SEL_2             2    //1/4VDD
 *                              FVR_SEL_3             3    //NTC
 *                              FVR_SEL_4             4    //DACOUT
 *                              FVR_SEL_5             5    //TCKS(仅内部使用）
 *                              FVR_SEL_6             6    //BGR_OUT（仅内部使用）
 *                              FVR_SEL_7             7    //VLCD（仅内部使用）
 *     FVROFFSET(校准使能)
 *                              FVR_OFFSET_EN         1    //允许使能 
 *                              FVR_OFFSET_DIS        0    //禁止使能
*     FVR_TRIM(校准值)          0~31
 * *********************************************************************************/

void DAC_Config(unsigned char Vref,unsigned char DacMode,unsigned char Data,unsigned char state);
/***************************************************************************************
*  Function  :  DAC_Config  配置DAC
*  Parameters：
*           Vref：参考电压
*                             DAC_VDD    1     //DAC参考电压选择VDD
*                             DAC_FVR    0     //DAC参考电压选择FVR
*           DacMode：DAC抽头选择
*                             DAC_0      0     //Vdac = (1/5)DAC_VREF+[(n+1)/40]DAC_VREF, n = DAC[3:0] in decimal
*                             DAC_1      1     //Vdac = [(n+1)/32]DAC_VREF, n = DAC[3:0] in decimal
*                             DAC_2      2     //VDAC = (1/4)DAC_VREF+[(n+1)/32]DAC_VREF, n = DAC[3:0] in decimal
*                             DAC_3      3     //Vdac = [(n+1)/24]DAC_VREF, n = DAC[3:0] in decimal
*           Data：输出电压值选择   0 ~ 7
*           state：DAC使能                 
*                             DAC_EN     1     //使能DAC
*                             DAC_DIS    0     //禁止DAC
*
*
******************************************************************************************/
#endif
